/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.heartbeat;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import org.snf4j.core.DatagramServerHandler;
import org.snf4j.core.SelectorLoop;
import org.snf4j.core.factory.IDatagramHandlerFactory;
import org.snf4j.core.handler.IDatagramHandler;
import org.snf4j.core.session.ISessionConfig;
import org.snf4j.core.timer.DefaultTimer;
import org.snf4j.core.timer.ITimer;
import org.snf4j.example.heartbeat.HeartbeatHandler;
import org.snf4j.example.heartbeat.SessionConfig;

public class HeartbeatServer {
    static final String PREFIX = "org.snf4j.";
    static final int PORT = Integer.getInteger("org.snf4j.Port", 8001);
    static final int BEAT_PERIOD = Integer.getInteger("org.snf4j.BeatPeriod", 3000);
    static final int DOWN_PERIOD = Integer.getInteger("org.snf4j.DownPeriod", 10000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SelectorLoop loop = new SelectorLoop();
        final DefaultTimer timer = new DefaultTimer(true);
        try {
            loop.start();
            DatagramChannel channel = DatagramChannel.open();
            channel.configureBlocking(false);
            channel.socket().bind(new InetSocketAddress(PORT));
            loop.register(channel, (IDatagramHandler)new DatagramServerHandler(new IDatagramHandlerFactory(){

                public IDatagramHandler create(SocketAddress remoteAddress) {
                    return new HeartbeatHandler((ITimer)timer, BEAT_PERIOD, DOWN_PERIOD);
                }
            }, (ISessionConfig)new SessionConfig()));
            loop.join();
        }
        finally {
            loop.stop();
        }
    }
}

