/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.sctp;

import java.nio.ByteBuffer;
import java.util.List;
import org.snf4j.core.codec.IDecoder;
import org.snf4j.core.session.ISession;

public class Aggregator
implements IDecoder<ByteBuffer, ByteBuffer> {
    private final int size;
    private ByteBuffer buffer;

    Aggregator(int size) {
        this.size = size;
    }

    public Class<ByteBuffer> getInboundType() {
        return ByteBuffer.class;
    }

    public Class<ByteBuffer> getOutboundType() {
        return ByteBuffer.class;
    }

    public void decode(ISession session, ByteBuffer data, List<ByteBuffer> out) throws Exception {
        if (this.buffer == null) {
            if (data.remaining() == this.size) {
                out.add(data);
                return;
            }
            this.buffer = session.allocate(this.size);
        }
        if (data.remaining() <= this.buffer.remaining()) {
            this.buffer.put(data);
        } else {
            ByteBuffer dup = data.duplicate();
            dup.limit(dup.position() + this.buffer.remaining());
            this.buffer.put(dup);
            data.position(dup.position());
        }
        if (!this.buffer.hasRemaining()) {
            this.buffer.flip();
            out.add(this.buffer);
            this.buffer = null;
            this.decode(session, data, out);
        }
    }
}

