/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.sctp;

import com.sun.nio.sctp.MessageInfo;
import java.nio.ByteBuffer;
import java.util.Random;
import org.snf4j.core.ImmutableSctpMessageInfo;
import org.snf4j.core.allocator.IByteBufferAllocator;
import org.snf4j.core.allocator.ThreadLocalCachingAllocator;
import org.snf4j.core.factory.DefaultSessionStructureFactory;
import org.snf4j.core.factory.ISessionStructureFactory;
import org.snf4j.core.handler.AbstractSctpHandler;
import org.snf4j.core.session.ISctpSessionConfig;
import org.snf4j.example.sctp.SctpClient;
import org.snf4j.example.sctp.SessionConfig;

public class SctpServerHandler
extends AbstractSctpHandler {
    static final IByteBufferAllocator ALLOCATOR = new ThreadLocalCachingAllocator(true);
    static final ImmutableSctpMessageInfo COMPRESSED = ImmutableSctpMessageInfo.create((int)1);
    static final ImmutableSctpMessageInfo ENCODED = ImmutableSctpMessageInfo.create((int)1, (int)0, (boolean)true);
    static final ImmutableSctpMessageInfo OTHER = ImmutableSctpMessageInfo.create((int)0);
    static final ImmutableSctpMessageInfo[] STREAMS = new ImmutableSctpMessageInfo[]{COMPRESSED, ENCODED, OTHER};
    static final Random RANDOM = new Random(System.currentTimeMillis());

    ImmutableSctpMessageInfo randomStream() {
        return STREAMS[RANDOM.nextInt(STREAMS.length)];
    }

    ByteBuffer msg() {
        int size = SctpClient.SIZE;
        ByteBuffer data = this.getSession().allocate(size);
        for (int i = 0; i < size; ++i) {
            data.put((byte)i);
        }
        data.flip();
        return data;
    }

    void check(Object msg) {
        ByteBuffer buf = (ByteBuffer)msg;
        int size = SctpClient.SIZE;
        if (buf.remaining() != size) {
            throw new IllegalArgumentException("incorrect msg size");
        }
        ByteBuffer dup = buf.duplicate();
        byte[] bytes = new byte[size];
        dup.get(bytes);
        for (int i = 0; i < size; ++i) {
            if (bytes[i] == (byte)i) continue;
            throw new IllegalArgumentException("incorrect msg data");
        }
    }

    public void read(Object msg, MessageInfo msgInfo) {
        this.check(msg);
        this.getSession().writenf(msg, this.randomStream());
    }

    public void exception(Throwable t) {
        System.err.println("ERR: " + t);
    }

    public ISctpSessionConfig getConfig() {
        return (ISctpSessionConfig)new SessionConfig().setOptimizeDataCopying(true).setMinOutBufferCapacity(SctpClient.SIZE << 1);
    }

    public ISessionStructureFactory getFactory() {
        return new DefaultSessionStructureFactory(){

            public IByteBufferAllocator getAllocator() {
                return ALLOCATOR;
            }
        };
    }
}

