/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.sctp.multi;

import java.net.SocketAddress;

class AssociationContext {
    final SocketAddress peer;
    private final int maxCount;
    private int counter;
    private boolean blocked;
    int progress;

    AssociationContext(SocketAddress peer, int maxCount) {
        this.peer = peer;
        this.maxCount = maxCount;
    }

    void block() {
        this.blocked = true;
    }

    boolean isBlocked() {
        return this.blocked;
    }

    AssociationContext incCounter() {
        ++this.counter;
        return this;
    }

    boolean isDone() {
        return this.counter >= this.maxCount;
    }

    void resetCounter() {
        this.counter = 0;
        this.progress = 0;
    }

    boolean updateProgress() {
        int progress = this.counter / (this.maxCount / 10);
        if (progress > this.progress) {
            this.progress = progress;
            return true;
        }
        return false;
    }

    int getProgress() {
        return this.progress * 10;
    }
}

