/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.sctp.multi;

import com.sun.nio.sctp.Association;
import com.sun.nio.sctp.AssociationChangeNotification;
import com.sun.nio.sctp.HandlerResult;
import com.sun.nio.sctp.MessageInfo;
import com.sun.nio.sctp.Notification;
import com.sun.nio.sctp.SendFailedNotification;
import com.sun.nio.sctp.ShutdownNotification;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Set;
import org.snf4j.core.ImmutableSctpMessageInfo;
import org.snf4j.core.allocator.IByteBufferAllocator;
import org.snf4j.core.allocator.ThreadLocalCachingAllocator;
import org.snf4j.core.factory.DefaultSessionStructureFactory;
import org.snf4j.core.factory.ISessionStructureFactory;
import org.snf4j.core.handler.AbstractSctpHandler;
import org.snf4j.core.handler.ISctpHandler;
import org.snf4j.core.handler.SctpNotificationType;
import org.snf4j.core.handler.SessionEvent;
import org.snf4j.core.session.DefaultSctpSessionConfig;
import org.snf4j.core.session.ISctpMultiSession;
import org.snf4j.core.session.ISctpSessionConfig;
import org.snf4j.example.sctp.multi.AssociationContext;
import org.snf4j.example.sctp.multi.AssociationManager;
import org.snf4j.example.sctp.multi.Server;

class SctpMultiHandler
extends AbstractSctpHandler {
    static final IByteBufferAllocator ALLOCATOR = new ThreadLocalCachingAllocator(true);
    private final AssociationManager associations;

    SctpMultiHandler(SocketAddress ... peers) {
        this.associations = new AssociationManager((ISctpHandler)this, Server.MAX_COUNT, peers);
    }

    public ISctpMultiSession getSession() {
        return (ISctpMultiSession)super.getSession();
    }

    ImmutableSctpMessageInfo immutableMsgInfo(MessageInfo msgInfo) {
        return ImmutableSctpMessageInfo.create((Association)msgInfo.association(), (int)msgInfo.streamNumber());
    }

    public void read(Object msg, MessageInfo msgInfo) {
        AssociationContext ctx = this.associations.getContext(msgInfo.association());
        if (!ctx.isBlocked()) {
            if (ctx.incCounter().isDone()) {
                this.log("sending to " + ctx.peer + ": 100%");
                this.log("shutting down " + ctx.peer);
                this.getSession().shutdown(msgInfo.association());
                return;
            }
            if (ctx.updateProgress()) {
                this.log("sending to " + ctx.peer + ": " + ctx.getProgress() + "%");
            }
        }
        this.getSession().writenf(msg, this.immutableMsgInfo(msgInfo));
    }

    ByteBuffer initialMsg() {
        ByteBuffer msg = this.getSession().allocate(Server.SIZE);
        return msg;
    }

    public void event(SessionEvent event) {
        switch (event) {
            case READY: {
                this.log("open " + this.addresses(this.getSession().getLocalAddresses()));
                for (int i = 0; i < this.associations.contexts.length; ++i) {
                    AssociationContext ctx = this.associations.contexts[i];
                    this.log("sending to " + ctx.peer);
                    this.getSession().writenf(this.initialMsg(), ImmutableSctpMessageInfo.create((SocketAddress)ctx.peer, (int)1));
                }
                break;
            }
        }
    }

    String addresses(Set<SocketAddress> addresses) {
        StringBuilder sb = new StringBuilder();
        for (SocketAddress address : addresses) {
            sb.append(address);
            sb.append(';');
        }
        return sb.toString();
    }

    String prefix(Notification n) {
        Association a = n.association();
        if (a != null) {
            return "association=" + a.associationID() + " remote=" + this.addresses(this.getSession().getRemoteAddresses(a)) + " ";
        }
        return "association=n/a ";
    }

    void notification(AssociationChangeNotification n) {
        this.log(this.prefix(n) + "association_change(" + n.event().name() + ")");
        switch (n.event()) {
            case COMM_UP: {
                this.associations.getContext(n.association()).resetCounter();
                break;
            }
            case SHUTDOWN: {
                this.associations.getContext(n.association()).block();
            }
        }
    }

    void notification(SendFailedNotification n) {
        this.log(this.prefix(n) + "send_failed(to " + n.address() + ")");
        this.associations.getContext(n.address()).block();
    }

    void notification(ShutdownNotification n) {
        this.log(this.prefix(n) + "shutdown");
    }

    public HandlerResult notification(Notification notification, SctpNotificationType type) {
        switch (type) {
            case ASSOCIATION_CHANGE: {
                this.notification((AssociationChangeNotification)notification);
                break;
            }
            case SEND_FAILED: {
                this.notification((SendFailedNotification)notification);
                break;
            }
            case SHUTDOWN: {
                this.notification((ShutdownNotification)notification);
            }
        }
        return super.notification(notification, type);
    }

    void log(String msg) {
        System.out.println("[INFO] " + msg);
    }

    public void exception(Throwable t) {
        System.err.println("[ERROR] " + t);
    }

    public ISctpSessionConfig getConfig() {
        return (ISctpSessionConfig)new DefaultSctpSessionConfig().setOptimizeDataCopying(true);
    }

    public ISessionStructureFactory getFactory() {
        return new DefaultSessionStructureFactory(){

            public IByteBufferAllocator getAllocator() {
                return ALLOCATOR;
            }
        };
    }
}

