/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.sctp.multi;

import com.sun.nio.sctp.SctpMultiChannel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.snf4j.core.SctpRegistrator;
import org.snf4j.core.SelectorLoop;
import org.snf4j.core.handler.ISctpHandler;
import org.snf4j.example.sctp.multi.SctpMultiHandler;

class Server {
    static final String PREFIX = "org.snf4j.";
    static final int SIZE = Integer.getInteger("org.snf4j.Size", 512);
    static final int MAX_COUNT = Integer.getInteger("org.snf4j.MaxCount", 1000000);
    static final String HOST1 = System.getProperty("org.snf4j.Host1", "127.0.0.1");
    static final String HOST2 = System.getProperty("org.snf4j.Host2", "127.0.0.2");
    static final String PEER1 = System.getProperty("org.snf4j.Peer1", "127.0.0.1");
    static final String PEER2 = System.getProperty("org.snf4j.Peer2", "127.0.0.1");

    Server() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(int port, int port1, int port2) throws Exception {
        SelectorLoop loop = new SelectorLoop();
        InetSocketAddress peer1 = new InetSocketAddress(InetAddress.getByName(PEER1), port1);
        InetSocketAddress peer2 = new InetSocketAddress(InetAddress.getByName(PEER2), port2);
        try {
            loop.start();
            SctpMultiChannel channel = SctpMultiChannel.open();
            channel.configureBlocking(false);
            channel.bind(new InetSocketAddress(InetAddress.getByName(HOST1), port));
            channel.bindAddress(InetAddress.getByName(HOST2));
            SctpRegistrator.register((SelectorLoop)loop, (SctpMultiChannel)channel, (ISctpHandler)new SctpMultiHandler(peer1, peer2));
            loop.join();
        }
        finally {
            loop.stop();
        }
    }
}

