/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.websocket;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.channels.SocketChannel;
import org.snf4j.core.SelectorLoop;
import org.snf4j.core.StreamSession;
import org.snf4j.example.websocket.WebSocketClientHandler;
import org.snf4j.websocket.IWebSocketHandler;
import org.snf4j.websocket.SSLWebSocketSession;
import org.snf4j.websocket.WebSocketSession;

public class WebSocketClient {
    static final String PREFIX = "org.snf4j.";
    static final String HOST = System.getProperty("org.snf4j.Host", "127.0.0.1");
    static final boolean SECURE = Integer.getInteger("org.snf4j.Secure") != null;
    static final int PORT = Integer.getInteger("org.snf4j.Port", SECURE ? 8443 : 8080);
    static final boolean COMPRESS = System.getProperty("org.snf4j.Compress") != null;
    static final int SIZE = Integer.getInteger("org.snf4j.Size", 512);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SelectorLoop loop = new SelectorLoop();
        URI endpoint = new URI((SECURE ? "wss" : "ws") + "://" + HOST + ":" + PORT + "/echo");
        try {
            loop.start();
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.connect(new InetSocketAddress(InetAddress.getByName(HOST), PORT));
            if (SECURE) {
                loop.register(channel, (StreamSession)new SSLWebSocketSession((IWebSocketHandler)new WebSocketClientHandler(endpoint, COMPRESS), true));
            } else {
                loop.register(channel, (StreamSession)new WebSocketSession((IWebSocketHandler)new WebSocketClientHandler(endpoint, COMPRESS), true));
            }
            loop.join();
        }
        finally {
            loop.stop();
        }
    }
}

