/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.websocket;

import java.net.URI;
import org.snf4j.core.EndingAction;
import org.snf4j.core.handler.SessionEvent;
import org.snf4j.example.websocket.SessionConfig;
import org.snf4j.example.websocket.WebSocketClient;
import org.snf4j.websocket.AbstractWebSocketHandler;
import org.snf4j.websocket.IWebSocketSessionConfig;
import org.snf4j.websocket.extensions.IExtension;
import org.snf4j.websocket.extensions.compress.PerMessageDeflateExtension;
import org.snf4j.websocket.frame.BinaryFrame;

public class WebSocketClientHandler
extends AbstractWebSocketHandler {
    private final URI requestUri;
    private final boolean compress;

    WebSocketClientHandler(URI requestUri, boolean compress) {
        this.requestUri = requestUri;
        this.compress = compress;
    }

    public void read(Object msg) {
        this.getSession().writenf(msg);
    }

    public void event(SessionEvent event) {
        switch (event) {
            case READY: {
                byte[] payload = new byte[WebSocketClient.SIZE];
                for (int i = 0; i < payload.length; ++i) {
                    payload[i] = (byte)i;
                }
                this.getSession().writenf((Object)new BinaryFrame(payload));
            }
        }
    }

    public IWebSocketSessionConfig getConfig() {
        SessionConfig config = new SessionConfig(this.requestUri);
        config.setEndingAction(EndingAction.STOP);
        if (this.compress) {
            config.setSupportedExtensions(new IExtension[]{new PerMessageDeflateExtension()});
        }
        return config;
    }
}

