/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.websocket;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.snf4j.core.codec.IDecoder;
import org.snf4j.core.handler.SessionEvent;
import org.snf4j.core.session.IStreamSession;
import org.snf4j.example.websocket.IndexPageDecoder;
import org.snf4j.example.websocket.SessionConfig;
import org.snf4j.websocket.AbstractWebSocketHandler;
import org.snf4j.websocket.IWebSocketSession;
import org.snf4j.websocket.IWebSocketSessionConfig;
import org.snf4j.websocket.extensions.IExtension;
import org.snf4j.websocket.extensions.compress.PerMessageDeflateExtension;
import org.snf4j.websocket.frame.Frame;
import org.snf4j.websocket.frame.Opcode;
import org.snf4j.websocket.frame.PongFrame;
import org.snf4j.websocket.frame.TextFrame;

public class WebSocketServerHandler
extends AbstractWebSocketHandler {
    private static final String USER_ID = "user-id";
    private static final ConcurrentMap<Long, IStreamSession> sessions = new ConcurrentHashMap<Long, IStreamSession>();
    private final String host;
    private final boolean compress;
    private boolean chatMode;

    WebSocketServerHandler(String host, boolean compress) {
        this.host = host;
        this.compress = compress;
    }

    public void read(Object msg) {
        if (msg instanceof Frame) {
            this.handle((Frame)msg);
        }
    }

    void handle(Frame frame) {
        if (frame.getOpcode() == Opcode.PING) {
            this.getSession().writenf((Object)new PongFrame(frame.getPayload()));
        } else if (this.chatMode) {
            if (frame.getOpcode() == Opcode.TEXT) {
                this.send(((TextFrame)frame).getText());
            }
        } else {
            this.getSession().writenf((Object)frame);
        }
    }

    void send(String msg) {
        for (Long sessionId : sessions.keySet()) {
            IStreamSession session = (IStreamSession)sessions.get(sessionId);
            String source = session == this.getSession() ? "[me] " : "[" + this.getSession().getAttributes().get(USER_ID) + "] ";
            session.writenf((Object)new TextFrame(source + msg));
        }
    }

    public void event(SessionEvent event) {
        IWebSocketSession session = (IWebSocketSession)this.getSession();
        switch (event) {
            case CREATED: {
                session.getCodecPipeline().addFirst((Object)"index-page-decoder", (IDecoder)new IndexPageDecoder(this.host));
                break;
            }
            case READY: {
                this.chatMode = "/chat".equalsIgnoreCase(session.getHandshaker().getUri().getPath());
                if (!this.chatMode) break;
                session.getAttributes().put(USER_ID, session.getRemoteAddress());
                sessions.put(session.getId(), (IStreamSession)session);
                this.send("connected");
                break;
            }
            case CLOSED: {
                if (!this.chatMode || sessions.remove(session.getId()) == null) break;
                this.send("disconnected");
            }
        }
    }

    public IWebSocketSessionConfig getConfig() {
        SessionConfig config = new SessionConfig();
        if (this.compress) {
            config.setSupportedExtensions(new IExtension[]{new PerMessageDeflateExtension()});
        }
        return config;
    }
}

