/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.chat;

import java.util.HashMap;
import java.util.Map;
import org.snf4j.core.handler.AbstractStreamHandler;
import org.snf4j.core.handler.SessionEvent;
import org.snf4j.core.session.IStreamSession;

public class ChatServerHandler
extends AbstractStreamHandler {
    private static Integer USERID = 0;
    private static String YOUID = "[you]";
    static final Map<Long, IStreamSession> sessions = new HashMap<Long, IStreamSession>();

    public void read(Object msg) {
        String s = new String((byte[])msg);
        this.send(s);
        if ("bye".equalsIgnoreCase(s)) {
            this.getSession().close();
        }
    }

    public void event(SessionEvent event) {
        switch (event) {
            case OPENED: {
                sessions.put(this.getSession().getId(), this.getSession());
                this.getSession().getAttributes().put(USERID, "[" + this.getSession().getRemoteAddress() + "]");
                this.send("{connected}");
                break;
            }
            case CLOSED: {
                sessions.remove(this.getSession().getId());
                this.send("{disconnected}");
            }
        }
    }

    private void send(String message) {
        long youId = this.getSession().getId();
        String userId = (String)this.getSession().getAttributes().get(USERID);
        for (IStreamSession session : sessions.values()) {
            session.write(((session.getId() == youId ? YOUID : userId) + ' ' + message).getBytes());
        }
    }
}

