/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.sctp;

import com.sun.nio.sctp.MessageInfo;
import org.snf4j.core.codec.DefaultCodecExecutor;
import org.snf4j.core.codec.ICodecExecutor;
import org.snf4j.core.codec.ICodecPipeline;
import org.snf4j.core.codec.IDecoder;
import org.snf4j.core.codec.IEncoder;
import org.snf4j.core.codec.bytes.BufferToArrayEncoder;
import org.snf4j.core.codec.zip.ZlibDecoder;
import org.snf4j.core.codec.zip.ZlibEncoder;
import org.snf4j.core.session.DefaultSctpSessionConfig;
import org.snf4j.core.session.ISctpSessionConfig;
import org.snf4j.example.sctp.Aggregator;
import org.snf4j.example.sctp.Decoder;
import org.snf4j.example.sctp.Encoder;
import org.snf4j.example.sctp.SctpClient;

public class SessionConfig
extends DefaultSctpSessionConfig {
    static final int CODEC_STREAM_NUMBER = 1;
    static final Object COMPRESSING_CODEC_EXECUTOR_IDENTIFIER = new Object();

    public Object getCodecExecutorIdentifier(MessageInfo msgInfo) {
        if (msgInfo.streamNumber() == 1) {
            return msgInfo.isUnordered() ? ISctpSessionConfig.DEFAULT_CODEC_EXECUTOR_IDENTIFIER : COMPRESSING_CODEC_EXECUTOR_IDENTIFIER;
        }
        return null;
    }

    public ICodecExecutor createCodecExecutor() {
        DefaultCodecExecutor executor = new DefaultCodecExecutor();
        ICodecPipeline pipeline = executor.getPipeline();
        pipeline.add((Object)"D1", (IDecoder)new Decoder());
        pipeline.add((Object)"E1", (IEncoder)new Encoder());
        return executor;
    }

    public ICodecExecutor createCodecExecutor(Object identifier) {
        if (identifier == COMPRESSING_CODEC_EXECUTOR_IDENTIFIER) {
            DefaultCodecExecutor executor = new DefaultCodecExecutor();
            ICodecPipeline pipeline = executor.getPipeline();
            pipeline.add((Object)"D1", (IDecoder)new ZlibDecoder(){

                protected int inflateBound(int len) {
                    return SctpClient.SIZE;
                }
            });
            pipeline.add((Object)"D2", (IDecoder)new Aggregator(SctpClient.SIZE));
            pipeline.add((Object)"E1", (IEncoder)new ZlibEncoder());
            pipeline.add((Object)"E2", (IEncoder)new BufferToArrayEncoder(true));
            return executor;
        }
        return null;
    }
}

