package org.somda.dsl.biceps

import org.somda.dsl.biceps.base.tree.ComponentTree

/**
 * Interface for MDIB post-processors.
 *
 * Register MDIB post-processors by using [installPostProcessor].
 */
public interface MdibPostProcessor {
    /**
     * Human-readable name for the post-processor instance.
     */
    public val name: String

    /**
     * Called on each post-processor.
     *
     * Use [ComponentTree.Root.traversePreOrder] or [ComponentTree.Node.traversePreOrder] to navigate the MDIB tree.
     *
     * Current limitations: It is not possible to remove or change list items, items can be appended though.
     */
    public fun run(
        mdib: Mdib,
        componentTree: ComponentTree.Root
    ) {
    }
}