package org.somda.dsl.biceps.alert


import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.AlertConditionKind
import org.somda.dsl.biceps.base.AlertConditionPriority
import org.somda.dsl.biceps.base.AlertSignalManifestation
import org.somda.dsl.biceps.base.AlertSignalPresence
import org.somda.dsl.biceps.base.AlertSignalPrimaryLocation
import org.somda.dsl.biceps.base.CauseInfo
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.HandleRef
import org.somda.dsl.biceps.checkUnset
import org.somda.dsl.biceps.uniqueHandle
import kotlin.time.Duration

public sealed interface AlertConditionBase

@MdibDsl
public open class AlertConditionState : AlertState() {
    public var actualConditionGenerationDelay: Duration? = null
        private set

    public var actualPriority: AlertConditionPriority? = null
        private set

    public var rank: Int? = null
        private set

    public var presence: Boolean? = null
        private set

    public fun rank(init: Int): Int = init.also {
        checkUnset(rank, "rank") {
            rank = it
        }
    }

    public fun actualPriority(init: AlertConditionPriority): AlertConditionPriority = init.also {
        checkUnset(actualPriority, "actualPriority") {
            actualPriority = it
        }
    }

    public fun actualPriority(init: Duration): Duration = init.also {
        checkUnset(actualConditionGenerationDelay, "actualConditionGenerationDelay") {
            actualConditionGenerationDelay = it
        }
    }
    
    public fun presence(init: Boolean): Boolean = init.also {
        checkUnset(presence, "presence") {
            presence = it
        }
    }
}

@MdibDsl
public class AlertCondition(
    handle: Handle,
    public val kind: AlertConditionKind,
    public val priority: AlertConditionPriority,
    private val addSignalToAlertSystem: (AlertSignal) -> Unit
) : Alert<AlertConditionState>(handle, { AlertConditionState() }), AlertConditionBase {
    private val sourceList: MutableList<HandleRef> = mutableListOf()

    private val causeInfoList: MutableList<CauseInfo> = mutableListOf()

    public var defaultConditionGenerationDelay: Duration? = null
        private set

    public var canEscalate: AlertConditionPriority? = null
        private set

    public var canDeescalate: AlertConditionPriority? = null
        private set

    public fun source(vararg init: HandleRef) {
        sourceList.addAll(init)
    }

    public val sources: List<HandleRef> = sourceList


    public fun causeInfo(init: CauseInfo.() -> Unit): CauseInfo {
        return CauseInfo().apply(init).also {
            causeInfoList.add(it)
        }
    }

    public val causeInfos: List<CauseInfo> = causeInfoList

    public fun defaultConditionGenerationDelay(init: Duration) {
        checkUnset(defaultConditionGenerationDelay, "defaultConditionGenerationDelay") {
            defaultConditionGenerationDelay = init
        }
    }

    public fun canEscalate(init: AlertConditionPriority) {
        checkUnset(canEscalate, "canEscalate") {
            canEscalate = init
        }
    }

    public fun canDeescalate(init: AlertConditionPriority) {
        checkUnset(canDeescalate, "canDeescalate") {
            canDeescalate = init
        }
    }

    public fun alertSignal(
        handle: Handle = uniqueHandle(),
        manifestation: AlertSignalManifestation,
        init: AlertSignal.() -> Unit = {}
    ): AlertSignal {
        return AlertSignal(handle, manifestation, this.handle.ref).apply(init).also {
            addSignalToAlertSystem(it)
        }
    }
}