package org.somda.dsl.biceps.alert

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.AlertConditionKind
import org.somda.dsl.biceps.base.AlertConditionPriority
import org.somda.dsl.biceps.base.AlertSignalManifestation
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.HandleRef
import org.somda.dsl.biceps.base.Range
import org.somda.dsl.biceps.checkUnset
import org.somda.dsl.biceps.preProcess
import org.somda.dsl.biceps.uniqueHandle
import kotlin.time.Duration


@MdibDsl
public class AlertSystemState : AlertState() {
    // todo currently none of the state's properties are populated by the dsl
}

@MdibDsl
public class AlertSystem(
    handle: Handle
) : Alert<AlertSystemState>(handle, { AlertSystemState() }) {
    private val alertConditionList: MutableList<AlertConditionBase> = mutableListOf()
    private val alertSignalList: MutableList<AlertSignal> = mutableListOf()

    public var selfCheckPeriod: Duration? = null
        private set

    public var maxPhysiologicalParallelAlarms: Long? = null
        private set

    public var maxTechnicalParallelAlarms: Long? = null
        private set

    public fun maxPhysiologicalParallelAlarms(init: Long): Long = init.also {
        checkUnset(maxPhysiologicalParallelAlarms, "maxPhysiologicalParallelAlarms") {
            maxPhysiologicalParallelAlarms = init
        }
    }

    public fun maxTechnicalParallelAlarms(init: Long): Long = init.also {
        checkUnset(maxTechnicalParallelAlarms, "maxTechnicalParallelAlarms") {
            maxTechnicalParallelAlarms = init
        }
    }

    public fun maxPhysiologicalParallelAlarms(init: Int): Int = init.also {
        maxPhysiologicalParallelAlarms(init.toLong())
    }

    public fun maxTechnicalParallelAlarms(init: Int): Int = init.also {
        maxTechnicalParallelAlarms(init.toLong())
    }

    public fun alertCondition(
        handle: Handle = uniqueHandle(),
        kind: AlertConditionKind,
        priority: AlertConditionPriority,
        init: AlertCondition.() -> Unit = {}
    ): AlertCondition {
        return AlertCondition(handle, kind, priority, ::addAlertSignal).preProcess {
            it.apply(init)
            alertConditionList.add(it)
        }
    }

    public fun limitAlertCondition(
        handle: Handle = uniqueHandle(),
        kind: AlertConditionKind,
        priority: AlertConditionPriority,
        maxLimits: Range,
        init: LimitAlertCondition.() -> Unit = {}
    ): LimitAlertCondition {
        return LimitAlertCondition(handle, kind, priority, maxLimits, ::addAlertSignal).preProcess {
            it.apply(init)
            alertConditionList.add(it)
        }
    }

    public val alertConditions: List<AlertConditionBase> = alertConditionList

    public fun alertSignal(
        handle: Handle = uniqueHandle(),
        manifestation: AlertSignalManifestation,
        conditionSignaled: HandleRef? = null,
        init: AlertSignal.() -> Unit = {}
    ): AlertSignal {
        return AlertSignal(handle, manifestation, conditionSignaled).preProcess {
            it.apply(init)
            addAlertSignal(it)
        }
    }

    public val alertSignals: List<AlertSignal> = alertSignalList

    public fun selfCheckPeriod(init: Duration): Duration = init.also {
        checkUnset(selfCheckPeriod, "selfCheckPeriod") {
            selfCheckPeriod = init
        }
    }

    private fun addAlertSignal(init: AlertSignal) {
        alertSignalList.add(init)
    }
}