package org.somda.dsl.biceps.base

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.tree.Extension
import org.somda.dsl.biceps.checkUnset
import java.math.BigInteger

@MdibDsl
public class CauseInfo {
    // todo extension: currently unused
    public var extension: Extension? = null
        private set

    public var remedyInfo: RemedyInfo? = null
        private set

    private var descriptionList: MutableList<LocalizedText> = mutableListOf()

    public fun remedyInfo(init: RemedyInfo.() -> Unit): RemedyInfo = RemedyInfo()
        .apply(init).also {
        checkUnset(this.remedyInfo, "remedyInfo") {
            remedyInfo = it
        }
    }

    public fun description(lang: String, value: () -> String = { "" }): LocalizedTextValue {
        return LocalizedTextValue(value(), lang).also {
            descriptionList.add(it)
        }
    }

    public fun descriptionRef(ref: String, version: BigInteger = BigInteger.ZERO): LocalizedTextReference {
        return LocalizedTextReference(ref, version).also {
            descriptionList.add(it)
        }
    }

    public val descriptions: List<LocalizedText> = descriptionList
}