package org.somda.dsl.biceps.base

import java.math.BigDecimal

@JvmInline
public value class Decimal internal constructor(public val value: BigDecimal)

public fun decimal(value: BigDecimal): Decimal = Decimal(value)

public fun decimal(value: String): Decimal = Decimal(value.toBigDecimal())

public fun decimal(value: Long): Decimal = Decimal(value.toBigDecimal())

public fun decimal(value: Int): Decimal = Decimal(value.toBigDecimal())