package org.somda.dsl.biceps.base

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.tree.ExtensibleMdibComponent

@MdibDsl
public abstract class MetricValue(public val metricQuality: MetricQuality) : ExtensibleMdibComponent() {
    private val annotationList: MutableList<Annotation> = mutableListOf()

    public fun annotation(type: CodedValue, init: Annotation.() -> Unit = {}): Annotation {
        return Annotation(type).apply(init).also {
            annotationList.add(it)
        }
    }

    public val annotations: List<Annotation> = annotationList

    public class Annotation(public val type: CodedValue) : ExtensibleMdibComponent()
}