package org.somda.dsl.biceps.base.tree


import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.CodedValue
import org.somda.dsl.biceps.base.ComponentActivation
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.PhysicalConnectorInfo
import org.somda.dsl.biceps.base.ProductionSpecification
import org.somda.dsl.biceps.checkUnset

@MdibDsl
public abstract class DeviceComponentState : VersionedMdibComponent() {
    // todo calibrationInfo: currently unused
    // calibrationInfo
    // todo nextCalibration: currently unused
    // nextCalibration
    // todo operatingHours: currently unused
    // operatingHours: Long? = null
    // todo operatingCycles: currently unused
    // operatingCycles: Int? = null

    public var physicalConnector: PhysicalConnectorInfo? = null

    public var activationState: ComponentActivation? = null

    public fun activationState(init: ComponentActivation): ComponentActivation = init.also {
        checkUnset(activationState, "activationState") {
            activationState = it
        }
    }

    public fun physicalConnector(init: PhysicalConnectorInfo.() -> Unit): PhysicalConnectorInfo {
        return PhysicalConnectorInfo().apply(init).also {
            checkUnset(physicalConnector, "physicalConnector") {
                physicalConnector = it
            }
        }
    }
}

@MdibDsl
public abstract class DeviceComponent<T : Any>(
    handle: Handle, newState: () -> T
) : Descriptor<T>(handle, newState) {

    private val productionSpecificationList: MutableList<ProductionSpecification> = mutableListOf()

    public fun productionSpecification(
        productionSpec: String,
        specType: CodedValue,
        init: ProductionSpecification.() -> Unit = {}
    ): ProductionSpecification = ProductionSpecification(productionSpec, specType).apply(init).also {
        productionSpecificationList.add(it)
    }

    public val productionSpecifications: List<ProductionSpecification> = productionSpecificationList
}