package org.somda.dsl.biceps.base.tree

import org.somda.dsl.biceps.Cursor
import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.checkUnset
import org.somda.dsl.biceps.currentScope
import java.math.BigInteger


internal object MustUnderstand

@MdibDsl
public abstract class Extension(public val name: String) {
    internal var mustUnderstand: MustUnderstand? = null
        private set

    public fun mustUnderstand() {
        checkUnset(mustUnderstand, "mustUnderstand") {
            mustUnderstand = MustUnderstand
        }
    }

    public fun isMustUnderstand(): Boolean = mustUnderstand != null
}

public abstract class IdentifiableMdibComponent(
    public val handle: Handle
) : VersionedMdibComponent()

public abstract class VersionedMdibComponent : ExtensibleMdibComponent() {
    public var version: BigInteger? = null
        private set

    public fun version(init: BigInteger): BigInteger = init.also {
        checkUnset(version, "version") {
            version = it
        }
    }

    public fun version(init: Int): Int = init.also {
        checkUnset(version, "version") {
            version = it.toBigInteger()
        }
    }

    public fun version(init: Long): Long = init.also {
        checkUnset(version, "version") {
            version = it.toBigInteger()
        }
    }
}

@MdibDsl
public abstract class ExtensibleMdibComponent {
    internal val extensionList: MutableList<Extension> = mutableListOf()

    public val cursor: Cursor = currentScope().cursor()

    public fun extendWith(init: Extensions.() -> Unit) {
        Extensions(this).apply(init)
    }

    public val extensions: List<Extension> = extensionList
}

@MdibDsl
public class Extensions(private val extensibleComponent: ExtensibleMdibComponent) {
    public fun add(extension: Extension) {
        extensibleComponent.extensionList.add(extension)
    }
}