package org.somda.dsl.biceps.component


import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.CodedValue
import org.somda.dsl.biceps.base.Decimal
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.Measurement
import org.somda.dsl.biceps.base.measurement
import org.somda.dsl.biceps.base.tree.DeviceComponent
import org.somda.dsl.biceps.base.tree.DeviceComponentState
import org.somda.dsl.biceps.checkUnset


@MdibDsl
public class BatteryState : DeviceComponentState()

@MdibDsl
public class Battery(
    handle: Handle
) : DeviceComponent<BatteryState>(handle, { BatteryState() }) {
    public var capacityFullCharge: Measurement? = null
        private set

    public var capacitySpecified: Measurement? = null
        private set

    public var voltageSpecified: Measurement? = null
        private set

    public fun capacityFullCharge(
        measuredValue: Decimal,
        measurementUnit: CodedValue,
        init: CodedValue.() -> Unit = {}
    ): Measurement = measurement(measuredValue, measurementUnit, init).also {
        checkUnset(capacityFullCharge, "capacityFullCharge") {
            capacityFullCharge = it
        }
    }

    public fun capacityFullCharge(
        measurement: Measurement
    ): Measurement = measurement.also {
        checkUnset(capacityFullCharge, "capacityFullCharge") {
            capacityFullCharge = it
        }
    }

    public fun capacitySpecified(
        measuredValue: Decimal,
        measurementUnit: CodedValue,
        init: CodedValue.() -> Unit = {}
    ): Measurement = measurement(measuredValue, measurementUnit, init).also {
        checkUnset(capacitySpecified, "capacitySpecified") {
            capacitySpecified = it
        }
    }

    public fun capacitySpecified(
        measurement: Measurement
    ): Measurement = measurement.also {
        checkUnset(capacitySpecified, "capacitySpecified") {
            capacitySpecified = it
        }
    }

    public fun voltageSpecified(
        measuredValue: Decimal,
        measurementUnit: CodedValue,
        init: CodedValue.() -> Unit = {}
    ): Measurement = measurement(measuredValue, measurementUnit, init).also {
        checkUnset(voltageSpecified, "voltageSpecified") {
            voltageSpecified = it
        }
    }

    public fun voltageSpecified(
        measurement: Measurement
    ): Measurement = measurement.also {
        checkUnset(voltageSpecified, "voltageSpecified") {
            voltageSpecified = it
        }
    }
}