package org.somda.dsl.biceps.component

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.CodedValue
import org.somda.dsl.biceps.base.Decimal
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.MetricAvailability
import org.somda.dsl.biceps.base.MetricCategory
import org.somda.dsl.biceps.base.Range
import org.somda.dsl.biceps.base.tree.ComplexDeviceComponent
import org.somda.dsl.biceps.base.tree.DeviceComponentState
import org.somda.dsl.biceps.metric.DistributionSampleArrayMetric
import org.somda.dsl.biceps.metric.EnumStringMetric
import org.somda.dsl.biceps.metric.Metric
import org.somda.dsl.biceps.metric.NumericMetric
import org.somda.dsl.biceps.metric.RealTimeSampleArrayMetric
import org.somda.dsl.biceps.metric.StringMetric
import org.somda.dsl.biceps.preProcess
import org.somda.dsl.biceps.uniqueHandle
import kotlin.time.Duration

@MdibDsl
public class ChannelState : DeviceComponentState()

@MdibDsl
public class Channel(
    handle: Handle
) : ComplexDeviceComponent<ChannelState>(handle, { ChannelState() }) {
    private val metricList: MutableList<Metric<*>> = mutableListOf()

    public fun stringMetric(
        handle: Handle = uniqueHandle(),
        metricCategory: MetricCategory,
        metricAvailability: MetricAvailability,
        unit: CodedValue,
        init: StringMetric.() -> Unit = {}
    ): StringMetric {
        return StringMetric(
            handle,
            metricCategory,
            metricAvailability,
            unit
        ).preProcess {
            it.apply(init)
            metricList.add(it)
        }
    }

    public fun enumStringMetric(
        handle: Handle = uniqueHandle(),
        metricCategory: MetricCategory,
        metricAvailability: MetricAvailability,
        unit: CodedValue,
        init: EnumStringMetric.() -> Unit = {}
    ): EnumStringMetric {
        return EnumStringMetric(
            handle,
            metricCategory,
            metricAvailability,
            unit
        ).preProcess {
            it.apply(init)
            metricList.add(it)
        }
    }

    public fun numericMetric(
        handle: Handle = uniqueHandle(),
        metricCategory: MetricCategory,
        metricAvailability: MetricAvailability,
        unit: CodedValue,
        resolution: Decimal,
        init: NumericMetric.() -> Unit = {}
    ): NumericMetric {
        return NumericMetric(
            handle,
            metricCategory,
            metricAvailability,
            unit,
            resolution
        ).preProcess {
            it.apply(init)
            metricList.add(it)
        }
    }

    public fun realTimeSampleArrayMetric(
        handle: Handle = uniqueHandle(),
        metricCategory: MetricCategory,
        metricAvailability: MetricAvailability,
        unit: CodedValue,
        resolution: Decimal,
        samplePeriod: Duration,
        init: RealTimeSampleArrayMetric.() -> Unit = {}
    ): RealTimeSampleArrayMetric {
        return RealTimeSampleArrayMetric(
            handle,
            metricCategory,
            metricAvailability,
            unit,
            resolution,
            samplePeriod
        ).preProcess {
            it.apply(init)
            metricList.add(it)
        }
    }

    public fun distributionSampleArrayMetric(
        handle: Handle = uniqueHandle(),
        metricCategory: MetricCategory,
        metricAvailability: MetricAvailability,
        unit: CodedValue,
        domainUnit: CodedValue,
        distributionRange: Range,
        resolution: Decimal,
        init: DistributionSampleArrayMetric.() -> Unit = {}
    ): DistributionSampleArrayMetric {
        return DistributionSampleArrayMetric(
            handle,
            metricCategory,
            metricAvailability,
            unit,
            domainUnit,
            distributionRange,
            resolution
        ).preProcess {
            it.apply(init)
            metricList.add(it)
        }
    }

    public fun metric(vararg metric: Metric<*>): List<Metric<*>> = metric.onEach {
        metricList.add(it)
    }.toList()

    public val metrics: List<Metric<*>> = metricList
}