package org.somda.dsl.biceps.component


import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.CodedValue
import org.somda.dsl.biceps.base.CriticalUse
import org.somda.dsl.biceps.base.Decimal
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.RemoteSynchronization
import org.somda.dsl.biceps.base.TimeZone
import org.somda.dsl.biceps.base.tree.DeviceComponent
import org.somda.dsl.biceps.base.tree.DeviceComponentState
import org.somda.dsl.biceps.checkUnset
import kotlin.time.Duration

@MdibDsl
public class ClockState : DeviceComponentState() {
    public var activeSyncProtocol: CodedValue? = null
        private set

    private val referenceSourceList: MutableList<String> = mutableListOf()

    private var remoteSynchronization: RemoteSynchronization? = null

    public var accuracy: Decimal? = null
        private set

    public var timeZone: TimeZone? = null
        private set

    private var criticalUse: CriticalUse? = null

    public fun referenceSource(vararg init: String): List<String> = init.also {
        referenceSourceList.addAll(it)
    }.toList()

    public val referenceSources: List<String> = referenceSourceList

    public fun activeSyncProtocol(base: CodedValue, init: CodedValue.() -> Unit = {}): CodedValue = base.apply(init).also {
        checkUnset(this.activeSyncProtocol, "activeSyncProtocol") {
            this.activeSyncProtocol = it
        }
    }

    public fun setRemoteSynchronization() {
        checkUnset(remoteSynchronization, "remoteSynchronization") {
            remoteSynchronization = RemoteSynchronization
        }
    }

    public fun isRemoteSynchronization(): Boolean = remoteSynchronization != null

    public fun accuracy(init: Decimal): Decimal = init.also {
        checkUnset(accuracy, "accuracy") {
            accuracy = it
        }
    }

    public fun timeZone(init: String): TimeZone = TimeZone(init).also {
        checkUnset(timeZone, "timeZone") {
            timeZone = it
        }
    }

    public fun setCriticalUse() {
        checkUnset(criticalUse, "criticalUse") {
            criticalUse = CriticalUse
        }
    }

    public fun isCriticalUse(): Boolean = criticalUse != null
}

@MdibDsl
public class Clock(
    handle: Handle
) : DeviceComponent<ClockState>(handle, { ClockState() }) {
    private val timeProtocolList: MutableList<CodedValue> = mutableListOf()

    public var resolution: Duration? = null
        private set

    public fun resolution(init: Duration): Duration = init.also {
        checkUnset(resolution, "resolution") {
            resolution = it
        }
    }

    public fun timeProtocol(base: CodedValue, init: CodedValue.() -> Unit = {}): CodedValue = base.apply(init).also {
        timeProtocolList.add(it)
    }

    public val timeProtocols: List<CodedValue> = timeProtocolList
}