package org.somda.dsl.biceps.component

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.InstanceIdentifier
import org.somda.dsl.biceps.base.tree.ComplexDeviceComponent
import org.somda.dsl.biceps.base.tree.DeviceComponentState
import org.somda.dsl.biceps.checkUnset
import org.somda.dsl.biceps.preProcess
import org.somda.dsl.biceps.uniqueHandle

@MdibDsl
public class VmdState : DeviceComponentState() {
    public var operatingJurisdiction: InstanceIdentifier? = null
        private set

    public fun operatingJurisdiction(init: InstanceIdentifier): InstanceIdentifier = init.also {
        checkUnset(this.operatingJurisdiction, "operatingJurisdiction") {
            this.operatingJurisdiction = it
        }
    }
}

@MdibDsl
public class Vmd(
    handle: Handle
) : ComplexDeviceComponent<VmdState>(handle, { VmdState() }) {
    private val channelList: MutableList<Channel> = mutableListOf()

    public fun channel(handle: Handle = uniqueHandle(), init: Channel.() -> Unit = {}): Channel {
        return Channel(handle).preProcess {
            it.apply(init)
            channelList.add(it)
        }
    }

    public fun channel(channel: Channel): Channel {
        return channel.also {
            channelList.add(channel)
        }
    }

    public val channels: List<Channel> = channelList
}