package org.somda.dsl.biceps.metric

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.CodedValue
import org.somda.dsl.biceps.base.Decimal
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.MetricAvailability
import org.somda.dsl.biceps.base.MetricCategory
import org.somda.dsl.biceps.base.MetricQuality
import org.somda.dsl.biceps.base.Range
import org.somda.dsl.biceps.base.SampleArrayValue
import org.somda.dsl.biceps.checkUnset
import kotlin.time.Duration

@MdibDsl
public class DistributionSampleArrayMetricState: MetricState() {
    public var metricValue: SampleArrayValue? = null
        private set

    private val physiologicalRangeList: MutableList<Range> = mutableListOf()

    public fun metricValue(metricQuality: MetricQuality, init: SampleArrayValue.() -> Unit): SampleArrayValue {
        return SampleArrayValue(metricQuality).apply(init).also {
            checkUnset(metricValue, "metricValue") {
                metricValue = it
            }
        }
    }

    public fun physiologicalRange(init: Range.() -> Unit): Range = Range().apply(init).also {
        physiologicalRangeList.add(it)
    }

    public val physiologicalRanges: List<Range> = physiologicalRangeList
}

@MdibDsl
public class DistributionSampleArrayMetric(
    handle: Handle,
    metricCategory: MetricCategory,
    metricAvailability: MetricAvailability,
    unit: CodedValue,
    public val domainUnit: CodedValue,
    public val distributionRange: Range,
    public val resolution: Decimal
) : Metric<DistributionSampleArrayMetricState>(
    handle,
    unit,
    metricCategory,
    metricAvailability,
    { DistributionSampleArrayMetricState() }
) {

    private val technicalRangeList: MutableList<Range> = mutableListOf()

    public fun technicalRange(init: Range.() -> Unit): Range = Range().apply(init).also {
        technicalRangeList.add(it)
    }

    public val technicalRanges: List<Range> = technicalRangeList
}