package org.somda.dsl.biceps.metric


import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.CodedValue
import org.somda.dsl.biceps.base.ComponentActivation
import org.somda.dsl.biceps.base.DerivationMethod
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.HandleRef
import org.somda.dsl.biceps.base.InstanceIdentifier
import org.somda.dsl.biceps.base.MetricAvailability
import org.somda.dsl.biceps.base.MetricCategory
import org.somda.dsl.biceps.base.PhysicalConnectorInfo
import org.somda.dsl.biceps.base.tree.Descriptor
import org.somda.dsl.biceps.base.tree.ExtensibleMdibComponent
import org.somda.dsl.biceps.base.tree.VersionedMdibComponent
import org.somda.dsl.biceps.checkUnset
import kotlin.time.Duration

public abstract class MetricState : VersionedMdibComponent() {
    private val bodySiteList: MutableList<CodedValue> = mutableListOf()

    public var physicalConnector: PhysicalConnectorInfo? = null
        private set

    public var activationState: ComponentActivation? = null
        private set

    public var activeDeterminationPeriod: Duration? = null
        private set

    public var lifeTimePeriod: Duration? = null
        private set

    public fun activationState(init: ComponentActivation): ComponentActivation = init.also {
        checkUnset(activationState, "activationState") {
            activationState = it
        }
    }

    public fun physicalConnector(init: PhysicalConnectorInfo.() -> Unit): PhysicalConnectorInfo {
        return PhysicalConnectorInfo().apply(init).also {
            checkUnset(physicalConnector, "physicalConnector") {
                physicalConnector = it
            }
        }
    }

    public fun bodySite(init: CodedValue): CodedValue = init.also {
        bodySiteList.add(init)
    }

    public val bodySites: List<CodedValue> = bodySiteList

    public fun activeDeterminationPeriod(init: Duration): Duration = init.also {
        checkUnset(activeDeterminationPeriod, "activeDeterminationPeriod") {
            activeDeterminationPeriod = it
        }
    }

    public fun lifeTimePeriod(init: Duration): Duration = init.also {
        checkUnset(lifeTimePeriod, "lifeTimePeriod") {
            lifeTimePeriod = it
        }
    }
}

public sealed class Metric<T : Any>(
    handle: Handle,
    public val unit: CodedValue,
    public val metricCategory: MetricCategory,
    public val metricAvailability: MetricAvailability,
    newState: () -> T
) : Descriptor<T>(handle, newState) {
    private val bodySiteList = mutableListOf<CodedValue>()

    public var derivationMethod: DerivationMethod? = null
        private set

    public var determinationPeriod: Duration? = null
        private set

    public var lifeTimePeriod: Duration? = null
        private set


    private val relationList: MutableList<Relation> = mutableListOf()

    public var maxMeasurementTime: Duration? = null
        private set

    public var maxDelayTime: Duration? = null
        private set

    public var activationDuration: Duration? = null
        private set

    public fun bodySite(init: CodedValue): CodedValue = init.also {
        bodySiteList.add(init)
    }

    public val bodySites: List<CodedValue> = bodySiteList

    public fun derivationMethod(init: DerivationMethod): DerivationMethod = init.also {
        checkUnset(derivationMethod, "derivationMethod") {
            derivationMethod = init
        }
    }

    public fun lifeTimePeriod(init: Duration): Duration = init.also {
        checkUnset(lifeTimePeriod, "lifeTimePeriod") {
            lifeTimePeriod = it
        }
    }

    public fun determinationPeriod(init: Duration): Duration = init.also {
        checkUnset(determinationPeriod, "determinationPeriod") {
            determinationPeriod = it
        }
    }

    public fun maxMeasurementTime(init: Duration): Duration = init.also {
        checkUnset(maxMeasurementTime, "maxMeasurementTime") {
            maxMeasurementTime = it
        }
    }

    public fun maxDelayTime(init: Duration): Duration = init.also {
        checkUnset(maxDelayTime, "maxDelayTime") {
            maxDelayTime = it
        }
    }

    public fun activationDuration(init: Duration): Duration = init.also {
        checkUnset(maxDelayTime, "maxDelayTime") {
            maxDelayTime = it
        }
    }

    public fun relation(kind: Relation.Kind, init: Relation.() -> Unit): Relation = Relation(kind).apply(init).also {
        relationList.add(it)
    }

    public val relations: List<Relation> = relationList

    @MdibDsl
    public class Relation(public val kind: Kind) : ExtensibleMdibComponent() {
        public var code: CodedValue? = null
            private set

        public var identification: InstanceIdentifier? = null
            private set

        private val entryList: MutableList<HandleRef> = mutableListOf()

        public fun code(base: CodedValue, init: CodedValue.() -> Unit = {}): CodedValue = base.apply(init).also {
            checkUnset(code, "code") {
                code = it
            }
        }

        public fun identification(init: InstanceIdentifier): InstanceIdentifier = init.also {
            checkUnset(identification, "identification") {
                identification = it
            }
        }

        public fun entry(init: HandleRef): HandleRef = init.also {
            entryList.add(init)
        }

        public val entries: List<HandleRef> = entryList

        public enum class Kind {
            RECOMMENDATION,
            PRE_SETTING,
            SET_OF_SUMMARY_STATISTICS,
            EFFECT_ON_CONTAINMENT_TREE_ENTRIES,
            DERIVED_FROM_CONTAINMENT_TREE_ENTRIES,
            OTHER
        }
    }
}
