package org.somda.dsl.biceps.metric

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.CodedValue
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.MetricAvailability
import org.somda.dsl.biceps.base.MetricCategory
import org.somda.dsl.biceps.base.MetricQuality
import org.somda.dsl.biceps.base.StringMetricValue
import org.somda.dsl.biceps.checkUnset

@MdibDsl
public class StringMetricState: MetricState() {
    public var metricValue: StringMetricValue? = null
        private set

    public fun metricValue(metricQuality: MetricQuality, init: StringMetricValue.() -> Unit = {}): StringMetricValue {
        return StringMetricValue(metricQuality).apply(init).also {
            checkUnset(metricValue, "metricValue") {
                metricValue = it
            }
        }
    }
}

@MdibDsl
public class StringMetric(
    handle: Handle,
    metricCategory: MetricCategory,
    metricAvailability: MetricAvailability,
    unit: CodedValue
) : Metric<StringMetricState>(
    handle,
    unit,
    metricCategory,
    metricAvailability,
    { StringMetricState() }
)