package org.somda.dsl.biceps.sco

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.CodedValue
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.HandleRef
import javax.xml.namespace.QName


@MdibDsl
public class ActivateOperationState : OperationState()

@MdibDsl
public class ActivateOperation(
    handle: Handle,
    operationTarget: HandleRef
) :
    Operation<ActivateOperationState>(handle, operationTarget, { ActivateOperationState() }) {

    private val argumentList: MutableList<Argument> = mutableListOf()

    public fun argument(name: CodedValue, type: QName): Argument = Argument(name, type).also {
        argumentList.add(it)
    }

    public val arguments: List<Argument> = argumentList

    public class Argument(
        public val name: CodedValue,
        public val type: QName
    )
}

