package org.somda.dsl.biceps.sco

import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.HandleRef
import org.somda.dsl.biceps.base.OperatingMode
import org.somda.dsl.biceps.base.Retriggerable
import org.somda.dsl.biceps.base.tree.Descriptor
import org.somda.dsl.biceps.base.tree.ExtensibleMdibComponent
import org.somda.dsl.biceps.base.tree.VersionedMdibComponent
import org.somda.dsl.biceps.checkUnset
import kotlin.time.Duration

public abstract class OperationState : VersionedMdibComponent() {
    public var operatingMode: OperatingMode? = null
        private set

    public fun operatingMode(init: OperatingMode): OperatingMode = init.also {
        checkUnset(operatingMode, "operatingMode") {
            operatingMode = it
        }
    }
}

public sealed class Operation<T : Any>(
    handle: Handle,
    public val operationTarget: HandleRef,
    newState: () -> T
) : Descriptor<T>(handle, newState, mapOf("operationTarget" to operationTarget.name)) {
    public var maxTimeToFinish: Duration? = null
        private set

    public var invocationEffectiveTimeout: Duration? = null
        private set

    private var retriggerable: Retriggerable? = null

    public var accessLevel: AccessLevel? = null
        private set

    public fun maxTimeToFinish(init: Duration): Duration = init.also {
        checkUnset(maxTimeToFinish, "maxTimeToFinish") {
            maxTimeToFinish = it
        }
    }

    public fun invocationEffectiveTimeout(init: Duration): Duration = init.also {
        checkUnset(invocationEffectiveTimeout, "invocationEffectiveTimeout") {
            invocationEffectiveTimeout = it
        }
    }

    public fun setRetriggerable() {
        checkUnset(retriggerable, "retriggerable") {
            retriggerable = Retriggerable
        }
    }

    public fun accessLevel(init: AccessLevel): AccessLevel = init.also {
        checkUnset(accessLevel, "accessLevel") {
            accessLevel = it
        }
    }

    public fun isRetriggerable(): Boolean = retriggerable != null

    public enum class AccessLevel {
        USER,
        CLINICAL_SUPER_USER,
        RESPONSIBLE_ORGANIZATION,
        SERVICE_PERSONNEL,
        OTHER
    }
}