package org.somda.dsl.biceps.validator

import org.somda.dsl.biceps.Mdib
import org.somda.dsl.biceps.MdibValidator
import org.somda.dsl.biceps.alert.AlertCondition
import org.somda.dsl.biceps.alert.AlertSystem
import org.somda.dsl.biceps.alert.LimitAlertCondition
import org.somda.dsl.biceps.base.tree.ComponentTree
import org.somda.dsl.biceps.component.Vmd
import org.somda.dsl.biceps.queueError

internal object AlertSourceValidator : MdibValidator {
    override val name: String = "AlertSourceValidator"

    override fun validate(mdib: Mdib, componentTree: ComponentTree.Root) {
        for (child in componentTree.children) {
            validateAlertSources(child)

            child.forAnyChildren<Vmd> { children ->
                children.forEach { validateAlertSources(it) }
            }
        }
    }

    private fun validateAlertSources(node: ComponentTree.Node<*>) {
        val potentialOperationTargets = node.fullClosure().map { it.component.handle.name }
        node.forFirstChild<AlertSystem> { alertSystem ->
            val children = alertSystem.anyChildren<AlertCondition>() + alertSystem.anyChildren<LimitAlertCondition>()
            children.forEach { child ->
                val sourceRefs = when (val comp = child.component) {
                    is LimitAlertCondition -> comp.sources
                    is AlertCondition -> comp.sources
                    else -> emptyList()
                }.map { it.name }

                for (ref in sourceRefs) {
                    if (!potentialOperationTargets.contains(ref)) {
                        queueError {
                            "Alert source '$ref' of alert condition '${child.component.handle.name}' " +
                                    "was not found below ${node.component}"
                        }
                    }
                }
            }
        }
    }
}