package org.somda.dsl.biceps.validator

import org.somda.dsl.biceps.Mdib
import org.somda.dsl.biceps.MdibValidator
import org.somda.dsl.biceps.base.tree.ComponentTree
import org.somda.dsl.biceps.component.Vmd
import org.somda.dsl.biceps.queueError
import org.somda.dsl.biceps.sco.Operation
import org.somda.dsl.biceps.sco.Sco

internal object OperationTargetValidator : MdibValidator {
    override val name: String = "OperationTargetValidator"

    override fun validate(mdib: Mdib, componentTree: ComponentTree.Root) {
        for (child in componentTree.children) {
            validateOperationTargets(child)

            child.forAnyChildren<Vmd> { children ->
                children.forEach { validateOperationTargets(it) }
            }
        }
    }

    private fun validateOperationTargets(node: ComponentTree.Node<*>) {
        val potentialOperationTargets = node.fullClosure().map { it.component.handle.name }
        node.forFirstChild<Sco> { sco ->
            sco.forAnyChildren<Operation<*>> { operations ->
                operations.forEach {
                    if (!potentialOperationTargets.contains(it.component.operationTarget.name)) {
                        queueError {
                            "Operation target '${it.component.operationTarget.name}' was not found below ${node.component}"
                        }
                    }
                }
            }
        }
    }
}