package org.somda.dsl.mpkp

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.Decimal
import org.somda.dsl.biceps.base.tree.Extension
import org.somda.dsl.biceps.base.tree.Extensions

@MdibDsl
public class DisplayPrecisionExtension(public val stepWidth: Decimal) : Extension("DisplayPrecision")

public fun Extensions.displayPrecision(
    stepWidth: Decimal,
    init: DisplayPrecisionExtension.() -> Unit = {},
) {
    add(DisplayPrecisionExtension(stepWidth).apply(init))
}