package org.somda.dsl.rendering.jaxb.mapping

import org.somda.dsl.biceps.context.EnsembleContext
import org.somda.dsl.biceps.context.LocationContext
import org.somda.dsl.biceps.context.PatientContext
import org.somda.sdc.biceps.model.participant.AbstractState
import org.somda.sdc.biceps.model.participant.EnsembleContextDescriptor
import org.somda.sdc.biceps.model.participant.LocationContextDescriptor
import org.somda.sdc.biceps.model.participant.PatientContextDescriptor

internal class ContextMapping(mappedStates: MutableList<AbstractState>) {
    private val baseMapping = BaseMapping(mappedStates)

    fun mapLocationContext(src: LocationContext): LocationContextDescriptor =
        LocationContextDescriptor().apply {
            baseMapping.mapIntoAbstractDescriptor(src, this)
        }

    fun mapPatientContext(src: PatientContext): PatientContextDescriptor =
        PatientContextDescriptor().apply {
            baseMapping.mapIntoAbstractDescriptor(src, this)
        }

    fun mapEnsembleContext(src: EnsembleContext): EnsembleContextDescriptor =
        EnsembleContextDescriptor().apply {
            baseMapping.mapIntoAbstractDescriptor(src, this)
        }
}