package org.somda.dsl.rendering.jaxb.mapping

import org.somda.dsl.rendering.jaxb.mapping.base.mapArgument
import org.somda.dsl.rendering.jaxb.mapping.base.mapRange
import org.somda.dsl.biceps.sco.ActivateOperation
import org.somda.dsl.biceps.sco.Operation
import org.somda.dsl.biceps.sco.SetAlertStateOperation
import org.somda.dsl.biceps.sco.SetComponentStateOperation
import org.somda.dsl.biceps.sco.SetContextStateOperation
import org.somda.dsl.biceps.sco.SetMetricStateOperation
import org.somda.dsl.biceps.sco.SetStringOperation
import org.somda.dsl.biceps.sco.SetValueOperation
import org.somda.sdc.biceps.model.participant.AbstractOperationDescriptor
import org.somda.sdc.biceps.model.participant.AbstractState
import org.somda.sdc.biceps.model.participant.ActivateOperationDescriptor
import org.somda.sdc.biceps.model.participant.ActivateOperationState
import org.somda.sdc.biceps.model.participant.SetAlertStateOperationDescriptor
import org.somda.sdc.biceps.model.participant.SetAlertStateOperationState
import org.somda.sdc.biceps.model.participant.SetComponentStateOperationDescriptor
import org.somda.sdc.biceps.model.participant.SetComponentStateOperationState
import org.somda.sdc.biceps.model.participant.SetContextStateOperationDescriptor
import org.somda.sdc.biceps.model.participant.SetContextStateOperationState
import org.somda.sdc.biceps.model.participant.SetMetricStateOperationDescriptor
import org.somda.sdc.biceps.model.participant.SetMetricStateOperationState
import org.somda.sdc.biceps.model.participant.SetStringOperationDescriptor
import org.somda.sdc.biceps.model.participant.SetStringOperationState
import org.somda.sdc.biceps.model.participant.SetValueOperationDescriptor
import org.somda.sdc.biceps.model.participant.SetValueOperationState

internal class OperationMapping(private val mappedStates: MutableList<AbstractState>) {
    private val baseMapping = BaseMapping(mappedStates)

    fun mapOperation(src: Operation<*>): AbstractOperationDescriptor {
        return when (src) {
            is ActivateOperation -> mapActivateOperation(src)
            is SetAlertStateOperation -> mapSetAlertStateOperation(src)
            is SetComponentStateOperation -> mapSetComponentStateOperation(src)
            is SetContextStateOperation -> mapSetContextStateOperation(src)
            is SetMetricStateOperation -> mapSetMetricStateOperation(src)
            is SetStringOperation -> mapSetStringOperation(src)
            is SetValueOperation -> mapSetValueOperation(src)
        }
    }

    private fun mapSetValueOperation(src: SetValueOperation): SetValueOperationDescriptor {
        return SetValueOperationDescriptor().apply {
            baseMapping.mapIntoAbstractOperationDescriptor(src, this)
            mappedStates.add(mapSetValueOperationState(src))
        }
    }

    private fun mapSetValueOperationState(src: SetValueOperation): SetValueOperationState {
        return SetValueOperationState().apply {
            baseMapping.mapIntoAbstractOperationState(src.state, src.handle.ref, src.version, this)
            src.state?.let {
                allowedRange = it.allowedRanges.map { rng -> mapRange(rng) }
            }
        }
    }

    private fun mapSetStringOperation(src: SetStringOperation): SetStringOperationDescriptor {
        return SetStringOperationDescriptor().apply {
            baseMapping.mapIntoAbstractOperationDescriptor(src, this)
            mappedStates.add(mapSetStringOperationState(src))
        }
    }

    private fun mapSetStringOperationState(src: SetStringOperation): SetStringOperationState {
        return SetStringOperationState().apply {
            baseMapping.mapIntoAbstractOperationState(src.state, src.handle.ref, src.version, this)
            src.state?.let {
                allowedValues = if (it.allowedValues.isNotEmpty()) {
                    SetStringOperationState.AllowedValues().apply {
                        this.value = it.allowedValues
                    }
                } else {
                    null
                }
            }
        }
    }

    private fun mapActivateOperation(src: ActivateOperation): ActivateOperationDescriptor {
        return ActivateOperationDescriptor().apply {
            baseMapping.mapIntoAbstractOperationDescriptor(src, this)
            argument = src.arguments.map { mapArgument(it) }
            mappedStates.add(mapActivateOperationState(src))
        }
    }

    private fun mapActivateOperationState(src: ActivateOperation): ActivateOperationState {
        return ActivateOperationState().apply {
            baseMapping.mapIntoAbstractOperationState(src.state, src.handle.ref, src.version, this)
        }
    }

    private fun mapSetAlertStateOperation(src: SetAlertStateOperation): SetAlertStateOperationDescriptor {
        return SetAlertStateOperationDescriptor().apply {
            baseMapping.mapIntoAbstractOperationDescriptor(src, this)
            mappedStates.add(mapSetAlertStateOperationState(src))
        }
    }

    private fun mapSetAlertStateOperationState(src: SetAlertStateOperation): SetAlertStateOperationState {
        return SetAlertStateOperationState().apply {
            baseMapping.mapIntoAbstractOperationState(src.state, src.handle.ref, src.version, this)
            src.state?.let {
                // todo
            }
        }
    }

    private fun mapSetComponentStateOperation(src: SetComponentStateOperation): SetComponentStateOperationDescriptor {
        return SetComponentStateOperationDescriptor().apply {
            baseMapping.mapIntoAbstractOperationDescriptor(src, this)
            mappedStates.add(mapSetComponentStateOperationState(src))
        }
    }

    private fun mapSetComponentStateOperationState(src: SetComponentStateOperation): SetComponentStateOperationState {
        return SetComponentStateOperationState().apply {
            baseMapping.mapIntoAbstractOperationState(src.state, src.handle.ref, src.version, this)
            src.state?.let {
                // todo
            }
        }
    }

    private fun mapSetContextStateOperation(src: SetContextStateOperation): SetContextStateOperationDescriptor {
        return SetContextStateOperationDescriptor().apply {
            baseMapping.mapIntoAbstractOperationDescriptor(src, this)
            mappedStates.add(mapSetContextStateOperationState(src))
        }
    }

    private fun mapSetContextStateOperationState(src: SetContextStateOperation): SetContextStateOperationState {
        return SetContextStateOperationState().apply {
            baseMapping.mapIntoAbstractOperationState(src.state, src.handle.ref, src.version, this)
            src.state?.let {
                // todo
            }
        }
    }

    private fun mapSetMetricStateOperation(src: SetMetricStateOperation): SetMetricStateOperationDescriptor {
        return SetMetricStateOperationDescriptor().apply {
            baseMapping.mapIntoAbstractOperationDescriptor(src, this)
            mappedStates.add(mapSetMetricStateOperationState(src))
        }
    }

    private fun mapSetMetricStateOperationState(src: SetMetricStateOperation): SetMetricStateOperationState {
        return SetMetricStateOperationState().apply {
            baseMapping.mapIntoAbstractOperationState(src.state, src.handle.ref, src.version, this)
            src.state?.let {
                // todo
            }
        }
    }
}