package org.somda.dsl.rendering.jaxb.mapping.base

import org.somda.sdc.biceps.model.participant.MeasurementValidity

public fun mapMeasurementValidity(src: org.somda.dsl.biceps.base.MeasurementValidity?): MeasurementValidity? {
    return src?.let {
        when (it) {
            org.somda.dsl.biceps.base.MeasurementValidity.VALID -> MeasurementValidity.VLD
            org.somda.dsl.biceps.base.MeasurementValidity.VALIDATED_DATA -> MeasurementValidity.VLDATED
            org.somda.dsl.biceps.base.MeasurementValidity.MEASUREMENT_ONGOING -> MeasurementValidity.ONG
            org.somda.dsl.biceps.base.MeasurementValidity.QUESTIONABLE -> MeasurementValidity.QST
            org.somda.dsl.biceps.base.MeasurementValidity.CALIBRATION_ONGOING -> MeasurementValidity.CALIB
            org.somda.dsl.biceps.base.MeasurementValidity.INVALID -> MeasurementValidity.INV
            org.somda.dsl.biceps.base.MeasurementValidity.OVERFLOW -> MeasurementValidity.OFLW
            org.somda.dsl.biceps.base.MeasurementValidity.UNDERFLOW -> MeasurementValidity.UFLW
            org.somda.dsl.biceps.base.MeasurementValidity.NOT_AVAILABLE -> MeasurementValidity.NA
        }
    }
}