package org.somda.dsl.rendering.jaxb.mapping.base

import org.somda.dsl.biceps.metric.Metric
import org.somda.sdc.biceps.model.participant.AbstractMetricDescriptor.Relation

public fun mapRelation(src: Metric.Relation?): Relation? {
    return src?.let {
        Relation().apply {
            extension = makeOptionalExtension(it.extensions)
            code = mapCodedValue(it.code)
            identification = mapInstanceIdentifier(it.identification)
            entries = src.entries.map { it.name }
            kind = mapRelationKind(src.kind) ?: Relation.Kind.OTH
        }
    }
}