package org.somda.dsl.rendering.jaxb.mapping.base

import org.somda.dsl.biceps.metric.Metric
import org.somda.sdc.biceps.model.participant.AbstractMetricDescriptor.Relation

public fun mapRelationKind(src: Metric.Relation.Kind?): Relation.Kind? {
    return src?.let {
        when (it) {
            Metric.Relation.Kind.RECOMMENDATION -> Relation.Kind.RCM
            Metric.Relation.Kind.PRE_SETTING -> Relation.Kind.PS
            Metric.Relation.Kind.SET_OF_SUMMARY_STATISTICS -> Relation.Kind.SST
            Metric.Relation.Kind.EFFECT_ON_CONTAINMENT_TREE_ENTRIES -> Relation.Kind.ECE
            Metric.Relation.Kind.DERIVED_FROM_CONTAINMENT_TREE_ENTRIES -> Relation.Kind.DCE
            Metric.Relation.Kind.OTHER -> Relation.Kind.OTH
        }
    }
}