/*
 * Decompiled with CFR 0.152.
 */
package org.somda.dsl.rendering.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.glassfish.jaxb.runtime.marshaller.NamespacePrefixMapper;
import org.jetbrains.annotations.NotNull;
import org.somda.dsl.rendering.jaxb.DslJaxbMarshalling;
import org.somda.dsl.rendering.jaxb.JaxbContext;
import org.somda.dsl.rendering.jaxb.Namespace;
import org.somda.dsl.rendering.jaxb.NamespacePrefix;
import org.somda.dsl.rendering.jaxb.NamespacePrefixMapperConverter;
import org.somda.dsl.rendering.jaxb.XmlSchemaPath;
import org.w3c.dom.Document;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00122\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/somda/dsl/rendering/jaxb/DslJaxbMarshalling;", "", "contextPackages", "", "Lorg/somda/dsl/rendering/jaxb/JaxbContext;", "schemaPaths", "Lorg/somda/dsl/rendering/jaxb/XmlSchemaPath;", "namespaceMappings", "", "Lorg/somda/dsl/rendering/jaxb/Namespace;", "Lorg/somda/dsl/rendering/jaxb/NamespacePrefix;", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/Map;)V", "namespacePrefixMapper", "Lorg/glassfish/jaxb/runtime/marshaller/NamespacePrefixMapper;", "jaxbContext", "Ljakarta/xml/bind/JAXBContext;", "schema", "Ljavax/xml/validation/Schema;", "marshal", "", "objectToMarshal", "outputStream", "Ljava/io/OutputStream;", "generateTopLevelSchema", "resolveTargetNamespace", "", "url", "Ljava/net/URL;", "Companion", "mdib-dsl"})
public final class DslJaxbMarshalling {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NamespacePrefixMapper namespacePrefixMapper;
    @NotNull
    private final JAXBContext jaxbContext;
    @NotNull
    private Schema schema;
    @Deprecated
    @NotNull
    public static final String SAX_FEATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    @Deprecated
    @NotNull
    public static final String SAX_FEATURE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    @Deprecated
    @NotNull
    public static final String JAXB_MARSHALLER_PROPERTY_KEY = "org.glassfish.jaxb.namespacePrefixMapper";

    public DslJaxbMarshalling(@NotNull List<JaxbContext> contextPackages, @NotNull List<XmlSchemaPath> schemaPaths, @NotNull Map<Namespace, NamespacePrefix> namespaceMappings) {
        Map map;
        Intrinsics.checkNotNullParameter(contextPackages, (String)"contextPackages");
        Intrinsics.checkNotNullParameter(schemaPaths, (String)"schemaPaths");
        Intrinsics.checkNotNullParameter(namespaceMappings, (String)"namespaceMappings");
        Map $this$_init__u24lambda_u240 = map = MapsKt.toMutableMap(namespaceMappings);
        boolean bl = false;
        $this$_init__u24lambda_u240.put(Namespace.box-impl(Namespace.constructor-impl("http://www.w3.org/2001/XMLSchema-instance")), NamespacePrefix.box-impl(NamespacePrefix.constructor-impl("xsi")));
        Map namespaceMappingsExtended = map;
        this.namespacePrefixMapper = NamespacePrefixMapperConverter.INSTANCE.convert(namespaceMappingsExtended);
        String joinedContextPackages2 = CollectionsKt.joinToString$default((Iterable)contextPackages, (CharSequence)":", null, null, (int)0, null, (Function1)joinedContextPackages.1.INSTANCE, (int)30, null);
        try {
            this.jaxbContext = JAXBContext.newInstance((String)joinedContextPackages2);
        }
        catch (JAXBException e) {
            throw new RuntimeException("JAXB context could not be created for '" + joinedContextPackages2 + "'");
        }
        this.schema = this.generateTopLevelSchema(schemaPaths);
    }

    public final void marshal(@NotNull Object objectToMarshal, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)objectToMarshal, (String)"objectToMarshal");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty(JAXB_MARSHALLER_PROPERTY_KEY, (Object)this.namespacePrefixMapper);
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setSchema(this.schema);
        marshaller.marshal(objectToMarshal, outputStream);
    }

    private final Schema generateTopLevelSchema(List<XmlSchemaPath> schemaPaths) {
        String topLevelSchemaBeginning = "<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\">";
        String importPattern = "<xsd:import namespace=\"%s\" schemaLocation=\"%s\"/>";
        String topLevelSchemaEnd = "</xsd:schema>";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(topLevelSchemaBeginning);
        Iterator<XmlSchemaPath> iterator = schemaPaths.iterator();
        while (iterator.hasNext()) {
            URL schemaUrl;
            String path = iterator.next().unbox-impl();
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader.getResource(path) == null) {
                throw new IOException("Could not find schema for resource while loading in " + DslJaxbMarshalling.class.getSimpleName() + ": " + XmlSchemaPath.toString-impl(path));
            }
            String targetNamespace = this.resolveTargetNamespace(schemaUrl);
            Object[] objectArray = new Object[]{targetNamespace, schemaUrl};
            String string = String.format(importPattern, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            stringBuilder.append(string);
        }
        stringBuilder.append(topLevelSchemaEnd);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Schema schema = schemaFactory.newSchema(new StreamSource(new ByteArrayInputStream(byArray)));
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"newSchema(...)");
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String resolveTargetNamespace(URL url) {
        Closeable closeable = url.openStream();
        Throwable throwable = null;
        try {
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature(SAX_FEATURE_EXTERNAL_GENERAL_ENTITIES, false);
            factory.setFeature(SAX_FEATURE_EXTERNAL_PARAMETER_ENTITIES, false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            String string = document.getDocumentElement().getAttribute("targetNamespace");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttribute(...)");
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/somda/dsl/rendering/jaxb/DslJaxbMarshalling$Companion;", "", "<init>", "()V", "SAX_FEATURE_EXTERNAL_GENERAL_ENTITIES", "", "SAX_FEATURE_EXTERNAL_PARAMETER_ENTITIES", "JAXB_MARSHALLER_PROPERTY_KEY", "mdib-dsl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

