package org.somda.dsl.biceps

import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.handle
import org.somda.dsl.biceps.validator.HandleValidator
import java.util.*

private val generatedHandles = mutableSetOf<Handle>()

internal fun uniqueHandle(): Handle {
    while (true) {
        val handle = handle(UUID.randomUUID().toString().substring(0, 7))
        if (HandleValidator.contains(handle) || generatedHandles.contains(handle)) {
            continue
        }

        generatedHandles.add(handle)
        return handle
    }
}