package org.somda.dsl.biceps.alert

import org.somda.dsl.biceps.base.AlertActivation
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.tree.Descriptor
import org.somda.dsl.biceps.base.tree.StringProperties
import org.somda.dsl.biceps.base.tree.VersionedMdibComponent
import org.somda.dsl.biceps.checkUnset


public abstract class AlertState : VersionedMdibComponent() {
    public var activationState: AlertActivation? = null
        private set

    public fun activationState(init: AlertActivation): AlertActivation = init.also {
        checkUnset(activationState, "activationState") {
            activationState = it
        }
    }
}

public sealed class Alert<T : Any>(
    handle: Handle,
    newState: () -> T,
    additionalToStringProperties: StringProperties = emptyMap()
) : Descriptor<T>(handle, newState, additionalToStringProperties)