package org.somda.dsl.biceps.alert


import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.AcknowledgementSupport
import org.somda.dsl.biceps.base.AlertSignalManifestation
import org.somda.dsl.biceps.base.AlertSignalPresence
import org.somda.dsl.biceps.base.AlertSignalPrimaryLocation
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.HandleRef
import org.somda.dsl.biceps.base.Latching
import org.somda.dsl.biceps.base.SignalDelegationSupport
import org.somda.dsl.biceps.checkUnset
import kotlin.time.Duration

@MdibDsl
public class AlertSignalState : AlertState() {

    public var actualSignalGenerationDelay: Duration? = null
        private set

    public var presence: AlertSignalPresence? = null
        private set

    public var location: AlertSignalPrimaryLocation? = null
        private set

    public var slot: Long? = null
        private set

    public fun presence(init: AlertSignalPresence): AlertSignalPresence = init.also {
        checkUnset(presence, "presence") {
            presence = it
        }
    }

    public fun location(init: org.somda.dsl.biceps.base.AlertSignalPrimaryLocation): org.somda.dsl.biceps.base.AlertSignalPrimaryLocation =
        init.also {
            checkUnset(location, "location") {
                location = it
            }
        }

    public fun slot(init: Long): Long = init.also {
        checkUnset(slot, "slot") {
            slot = it
        }
    }

    public fun actualSignalGenerationDelay(init: Duration): Duration = init.also {
        checkUnset(actualSignalGenerationDelay, "actualSignalGenerationDelay") {
            actualSignalGenerationDelay = it
        }
    }
}

@MdibDsl
public class AlertSignal(
    handle: Handle,
    public val manifestation: AlertSignalManifestation,
    public val conditionSignaled: HandleRef? = null
) : Alert<AlertSignalState>(
    handle,
    { AlertSignalState() },
    mapOf("conditionSignaled" to conditionSignaled?.name)
) {
    private var latching: Latching? = null

    public var defaultSignalGenerationDelay: Duration? = null
        private set

    public var minSignalGenerationDelay: Duration? = null
        private set

    public var maxSignalGenerationDelay: Duration? = null
        private set

    private var signalDelegationSupported: SignalDelegationSupport? = null

    private var acknowledgementSupported: AcknowledgementSupport? = null

    public var acknowledgeTimeout: Duration? = null
        private set

    public fun latching() {
        checkUnset(latching, "latching") {
            latching = Latching
        }
    }

    public fun isLatching(): Boolean = latching != null

    public fun defaultSignalGenerationDelay(init: Duration) {
        checkUnset(
            defaultSignalGenerationDelay,
            "defaultSignalGenerationDelay"
        ) {
            defaultSignalGenerationDelay = init
        }
    }

    public fun minSignalGenerationDelay(init: Duration) {
        checkUnset(
            minSignalGenerationDelay,
            "minSignalGenerationDelay"
        ) {
            minSignalGenerationDelay = init
        }
    }

    public fun maxSignalGenerationDelay(init: Duration) {
        checkUnset(
            maxSignalGenerationDelay,
            "maxSignalGenerationDelay"
        ) {
            maxSignalGenerationDelay = init
        }
    }

    public fun signalDelegationSupported() {
        checkUnset(
            signalDelegationSupported,
            "signalDelegationSupported"
        ) {
            signalDelegationSupported = SignalDelegationSupport
        }
    }

    public fun isSignalDelegationSupported(): Boolean = signalDelegationSupported != null

    public fun acknowledgementSupported() {
        checkUnset(
            acknowledgementSupported,
            "acknowledgementSupported"
        ) {
            acknowledgementSupported = AcknowledgementSupport
        }
    }

    public fun isAcknowledgementSupported(): Boolean = acknowledgementSupported != null

    public fun acknowledgeTimeout(init: Duration) {
        checkUnset(acknowledgeTimeout, "acknowledgeTimeout") {
            acknowledgeTimeout = init
        }
    }
}