package org.somda.dsl.biceps.alert

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.AlertActivation
import org.somda.dsl.biceps.base.AlertConditionKind
import org.somda.dsl.biceps.base.AlertConditionMonitoredLimits
import org.somda.dsl.biceps.base.AlertConditionPriority
import org.somda.dsl.biceps.base.AlertSignalManifestation
import org.somda.dsl.biceps.base.AutoLimitSupport
import org.somda.dsl.biceps.base.CauseInfo
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.HandleRef
import org.somda.dsl.biceps.base.Range
import org.somda.dsl.biceps.checkUnset
import org.somda.dsl.biceps.uniqueHandle
import kotlin.time.Duration

@MdibDsl
public class LimitAlertConditionState : AlertState() {

    public var limits: Range? = null
        private set

    public var monitoredAlertLimits: AlertConditionMonitoredLimits? = null
        private set

    public var autoLimitActivationState: AlertActivation? = null
        private set

    public var actualConditionGenerationDelay: kotlin.time.Duration? = null
        private set

    public var actualPriority: AlertConditionPriority? = null
        private set

    public var rank: Int? = null
        private set

    public fun limits(init: Range): Range = init.also {
        checkUnset(limits, "limits") {
            limits = it
        }
    }

    public fun monitoredAlertLimits(init: AlertConditionMonitoredLimits): AlertConditionMonitoredLimits {
        return init.also {
            checkUnset(monitoredAlertLimits, "monitoredAlertLimits") {
                monitoredAlertLimits = it
            }
        }
    }

    public fun autoLimitActivationState(init: AlertActivation): AlertActivation = init.also {
        checkUnset(autoLimitActivationState, "autoLimitActivationState") {
            autoLimitActivationState = it
        }
    }

    public fun rank(init: Int): Int = init.also {
        checkUnset(rank, "rank") {
            rank = it
        }
    }

    public fun actualPriority(init: AlertConditionPriority): AlertConditionPriority = init.also {
        checkUnset(actualPriority, "actualPriority") {
            actualPriority = it
        }
    }

    public fun actualPriority(init: kotlin.time.Duration): kotlin.time.Duration = init.also {
        checkUnset(actualConditionGenerationDelay, "actualConditionGenerationDelay") {
            actualConditionGenerationDelay = it
        }
    }
}

@MdibDsl
public class LimitAlertCondition(
    handle: Handle,
    public val kind: AlertConditionKind,
    public val priority: AlertConditionPriority,
    public val maxLimits: Range,
    private val addSignalToAlertSystem: (AlertSignal) -> Unit,
) : Alert<LimitAlertConditionState>(handle, { LimitAlertConditionState() }), AlertConditionBase {
    private var sourceList: MutableList<HandleRef> = mutableListOf()
    private var causeInfoList: MutableList<CauseInfo> = mutableListOf()

    public var defaultConditionGenerationDelay: Duration? = null
        private set
    public var canEscalate: AlertConditionPriority? = null
        private set
    public var canDeescalate: AlertConditionPriority? = null
        private set
    private var autoLimitSupported: AutoLimitSupport? = null

    public fun source(init: HandleRef): HandleRef = init.also { sourceList.add(it) }

    public val sources: List<HandleRef> = sourceList

    public fun causeInfo(init: CauseInfo.() -> Unit): CauseInfo = CauseInfo().apply(init).also {
        causeInfoList.add(it)
    }

    public val causeInfos: List<CauseInfo> = causeInfoList

    public fun defaultConditionGenerationDelay(init: Duration): Duration = init.also {
        checkUnset(defaultConditionGenerationDelay, "defaultConditionGenerationDelay") {
            defaultConditionGenerationDelay = it
        }
    }

    public fun canEscalate(init: AlertConditionPriority): AlertConditionPriority = init.also {
        checkUnset(canEscalate, "canEscalate") {
            canEscalate = it
        }
    }

    public fun canDeescalate(init: AlertConditionPriority): AlertConditionPriority = init.also {
        checkUnset(canDeescalate, "canDeescalate") {
            canDeescalate = init
        }
    }

    public fun autoLimitSupported() {
        checkUnset(autoLimitSupported, "autoLimitSupported") {
            autoLimitSupported = AutoLimitSupport
        }
    }

    public fun isAutoLimitSupported(): Boolean = autoLimitSupported != null

    public fun alertSignal(
        handle: Handle = uniqueHandle(),
        manifestation: AlertSignalManifestation,
        init: AlertSignal.() -> Unit = {}
    ): AlertSignal = AlertSignal(handle, manifestation, this.handle.ref).apply(init).also {
        addSignalToAlertSystem(it)
    }
}