package org.somda.dsl.biceps.base

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.tree.Extension
import org.somda.dsl.biceps.checkUnset

@MdibDsl
public class ClinicalInfo {

    // todo extension: currently unused
    public var extension: Extension? = null
        private set

    public var type: CodedValue? = null
        private set

    public var code: CodedValue? = null
        private set

    public var criticality: Criticality? = null

    private val descriptionList = mutableListOf<LocalizedText>()

    private val relatedMeasurementList = mutableListOf<RelatedMeasurement>()

    public fun type(base: CodedValue, init: CodedValue.() -> Unit): CodedValue =
        CodedValue(base).apply(init).also {
            checkUnset(type, "type") {
                type = it
            }
        }

    public fun code(base: CodedValue, init: CodedValue.() -> Unit): CodedValue =
        CodedValue(base).apply(init).also {
            checkUnset(code, "code") {
                code = it
            }
        }

    public fun criticality(init: Criticality) {
        checkUnset(criticality, "criticality") {
            criticality = init
        }
    }

    public fun description(init: LocalizedText): LocalizedText =
        init.also { descriptionList.add(init) }

    public fun relatedMeasurement(value: Measurement, init: RelatedMeasurement.() -> Unit): RelatedMeasurement {
        return RelatedMeasurement(value).apply(init).also {
            relatedMeasurementList.add(it)
        }
    }

    public fun description(): List<LocalizedText> = descriptionList

    public fun relatedMeasurement(): List<RelatedMeasurement> = relatedMeasurementList

    public enum class Criticality {
        LOW,
        HIGH
    }

    @MdibDsl
    public class RelatedMeasurement(public val value: Measurement) {

        public constructor(base: RelatedMeasurement) : this(base.value)

        public var validity: MeasurementValidity? = null
            private set

        private val referenceRangeList = mutableListOf<ReferenceRange>()

        public fun validity(init: MeasurementValidity): MeasurementValidity =
            init.also {
                checkUnset(validity, "validity") {
                    validity = init
                }
            }

        public fun referenceRange(range: Range, init: ReferenceRange.() -> Unit): ReferenceRange {
            return ReferenceRange(range).apply(init).also {
                referenceRangeList.add(it)
            }
        }

        public fun referenceRange(): List<ReferenceRange> = referenceRangeList

        @MdibDsl
        public class ReferenceRange(
            public val range: Range,
        ) {
            public constructor(base: ReferenceRange): this(base.range)

            public var meaning: CodedValue? = null

            public fun meaning(base: CodedValue, init: CodedValue.() -> Unit = {}): CodedValue =
                CodedValue(base).apply(init).also {
                    checkUnset(meaning, "meaning") {
                        meaning = it
                    }
                }
        }
    }
}

