package org.somda.dsl.biceps.base

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.tree.Extension
import org.somda.dsl.biceps.checkUnset

@MdibDsl
public class ImagingProcedure {
    // todo extension: currently unused
    public var extension: Extension? = null
        private set

    public var accessionIdentifier: InstanceIdentifier? = null
        private set

    public var requestedProcedureId: InstanceIdentifier? = null
        private set

    public var studyInstanceUid: InstanceIdentifier? = null
        private set

    public var scheduledProcedureStepId: InstanceIdentifier? = null
        private set

    public var modality: CodedValue? = null
        private set

    public var protocolCode: CodedValue? = null
        private set


    public fun accessionIdentifier(init: InstanceIdentifier): InstanceIdentifier =
        init.also {
            checkUnset(accessionIdentifier, "accessionIdentifier") {
                accessionIdentifier = it
            }
        }

    public fun requestedProcedureId(init: InstanceIdentifier): InstanceIdentifier {
        return init.also {
            checkUnset(requestedProcedureId, "requestedProcedureId") {
                requestedProcedureId = it
            }
        }
    }

    public fun studyInstanceUid(init: InstanceIdentifier): InstanceIdentifier {
        return init.also {
            checkUnset(studyInstanceUid, "studyInstanceUid") {
                studyInstanceUid = it
            }
        }
    }
    
    public fun scheduledProcedureStepId(init: InstanceIdentifier): InstanceIdentifier {
        return init.also {
            checkUnset(scheduledProcedureStepId, "scheduledProcedureStepId") {
                scheduledProcedureStepId = it
            }
        }
    }

    public fun modality(base: CodedValue, init: CodedValue.() -> Unit = {}): CodedValue =
        CodedValue(base).apply(init).also {
            checkUnset(modality, "modality") {
                modality = it
            }
        }

    public fun protocolCode(base: CodedValue, init: CodedValue.() -> Unit = {}): CodedValue =
        CodedValue(base).apply(init).also {
            checkUnset(protocolCode, "protocolCode") {
                protocolCode = it
            }
        }
}