package org.somda.dsl.biceps.base

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.checkUnset
import org.somda.sdc.biceps.model.extension.ExtensionType
import java.math.BigInteger

@MdibDsl
public open class InstanceIdentifier {
    // todo: extension: currently unused
    public var extension: ExtensionType? = null
        private set

    public var type: CodedValue? = null
        private set

    private val identifierNameList: MutableList<LocalizedText> = mutableListOf()

    public var identifierRoot: String? = null
        private set

    public var identifierExtension: String? = null
        private set

    public fun type(base: CodedValue, init: CodedValue.() -> Unit = {}): CodedValue =
        CodedValue(base).apply(init).also {
            checkUnset(type, "type") {
                type = it
            }
        }

    public fun identifierRoot(init: String): String = init.also {
        checkUnset(this.identifierRoot, "identifier root") {
            this.identifierRoot = init
        }
    }

    public fun identifierExtension(init: String): String = init.also {
        checkUnset(this.identifierExtension, "identifier extension") {
            this.identifierExtension = it
        }
    }

    public fun identifierName(lang: String, value: () -> String = { "" }): LocalizedTextValue {
        return LocalizedTextValue(value(), lang).also {
            identifierNameList.add(it)
        }
    }

    public fun identifierNameRef(
        ref: String,
        version: BigInteger
    ): LocalizedTextReference {
        return LocalizedTextReference(ref, version).also {
            identifierNameList.add(it)
        }
    }

    public fun identifierName(text: LocalizedText): LocalizedText {
        return text.also {
            identifierNameList.add(it)
        }
    }

    public val identifierNames: List<LocalizedText> = identifierNameList
}

public fun instanceIdentifier(init: InstanceIdentifier.() -> Unit): InstanceIdentifier {
    return InstanceIdentifier().apply(init)
}

public fun root(init: String): InstanceIdentifier {
    return instanceIdentifier {
        identifierRoot(init)
    }
}

public infix fun InstanceIdentifier.extension(extensionName: String): InstanceIdentifier {
    return instanceIdentifier {
        identifierExtension(extensionName)
        this@extension.identifierRoot?.also { identifierRoot(it) }
    }
}