package org.somda.dsl.biceps.base

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.checkUnset
import java.math.BigInteger

@MdibDsl
public abstract class LocalizedText(
    public val value: String?,
    public val lang: String?,
    public val ref: String?,
    public val version: BigInteger?
) {
    public var textWidth: LocalizedTextWidth? = null
        private set

    public fun textWidth(init: LocalizedTextWidth): LocalizedTextWidth {
        return init.also {
            checkUnset(textWidth, "textWidth") {
                textWidth = it
            }
        }
    }
}

@MdibDsl
public open class LocalizedTextValue(value: String, lang: String) : LocalizedText(value, lang, null, null)

@MdibDsl
public open class LocalizedTextReference(ref: String, version: BigInteger, value: String = "") :
    LocalizedText(value, null, ref, version)

public fun text(lang: String, value: () -> String = { "" }): LocalizedTextValue {
    return LocalizedTextValue(value(), lang)
}

public fun textReference(ref: String, version: BigInteger, value: () -> String = { "" }): LocalizedTextReference {
    return LocalizedTextReference(ref, version, value())
}