package org.somda.dsl.biceps.base

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.tree.Extension
import org.somda.dsl.biceps.checkUnset

@MdibDsl
public class LocationReference {

    // todo extension: currently unused
    public var extension: Extension? = null
        private set

    private val identificationList: MutableList<InstanceIdentifier> = mutableListOf()

    public var locationDetail: LocationDetail? = null
        private set

    // TODO: minLength = 1
    public fun identification(init: InstanceIdentifier): InstanceIdentifier {
        return init.also {
            identificationList.add(it)
        }
    }

    public fun locationDetail(init: LocationDetail.() -> Unit = {}): LocationDetail {
        return LocationDetail().apply(init).also {
            checkUnset(locationDetail, "locationDetail") {
                locationDetail = it
            }
        }
    }

    public fun identification(): List<InstanceIdentifier> = identificationList

}