package org.somda.dsl.biceps.base

import org.somda.sdc.biceps.model.extension.ExtensionType
import org.somda.dsl.biceps.MdibDsl

@MdibDsl
public class Measurement(
    public val measuredValue: Decimal,
    public val measurementUnit: CodedValue
) {
    // todo extension: currently unusued
    public var extension: ExtensionType? = null
        private set
}

public fun measurement(
    measuredValue: Decimal,
    baseMeasurementUnit: CodedValue,
    init: CodedValue.() -> Unit = {}
): Measurement {
    return Measurement(
        measuredValue = measuredValue,
        measurementUnit = CodedValue(baseMeasurementUnit).apply(init)
    )
}