package org.somda.dsl.biceps.base

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.tree.ExtensibleMdibComponent
import org.somda.dsl.biceps.checkUnset

@MdibDsl
public class MetricQuality(public val validity: MeasurementValidity) : ExtensibleMdibComponent() {
    public var mode: GenerationMode? = null
        private set

    public var qualityIndicator: Decimal? = null
        private set

    public fun mode(init: GenerationMode): GenerationMode = init.also {
        checkUnset(mode, "mode") {
            mode = it
        }
    }

    public fun qualityIndicator(init: Decimal): Decimal = init.also {
        checkUnset(qualityIndicator, "qualityIndicator") {
            qualityIndicator = it
        }
    }
}

public fun metricQuality(validity: MeasurementValidity, init: MetricQuality.() -> Unit = {}): MetricQuality {
    return MetricQuality(validity).apply(init)
}