package org.somda.dsl.biceps.base

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.checkUnset
import org.somda.sdc.common.model.AnyDateTime

@MdibDsl
public open class OrderDetail {

    public var start: AnyDateTime? = null
        private set

    public var end: AnyDateTime? = null
        private set

    private val performerList = mutableListOf<PersonParticipation>()

    private val serviceList = mutableListOf<CodedValue>()

    private val imagingProcedureList = mutableListOf<ImagingProcedure>()

    public fun start(init: AnyDateTime): AnyDateTime =
        init.also {
            checkUnset(start, "start") {
                start = it
            }
        }

    public fun end(init: AnyDateTime): AnyDateTime =
        init.also {
            checkUnset(end, "end") {
                end = it
            }
        }

    public fun performer(init: PersonParticipation.() -> Unit): PersonParticipation =
        PersonParticipation().apply(init).also {
            performerList.add(it)
        }

    public fun service(base: CodedValue, init: CodedValue.() -> Unit): CodedValue =
        CodedValue(base).apply(init).also {
            serviceList.add(it)
        }

    public fun imagingProcedure(init: ImagingProcedure.() -> Unit) {
        ImagingProcedure().apply(init).also {
            imagingProcedureList.add(it)
        }
    }

    public fun performer(): List<PersonParticipation> = performerList

    public fun service(): List<CodedValue> = serviceList

    public fun imagingProcedure(): List<ImagingProcedure> = imagingProcedureList
}