package org.somda.dsl.biceps.base

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.tree.Extension
import org.somda.dsl.biceps.checkUnset

@MdibDsl
public open class PersonReference() {
    // todo extension: currently unused
    public var extension: Extension? = null
        private set

    private val identificationList: MutableList<InstanceIdentifier> = mutableListOf()

    public var name: BaseDemographics? = null
        private set

    // TODO: minLength = 1
    public fun identification(init: InstanceIdentifier): InstanceIdentifier {
        return init.also {
            identificationList.add(it)
        }
    }

    public fun name(init: BaseDemographics.() -> Unit = {}): BaseDemographics {
        return BaseDemographics().apply(init).also {
            checkUnset(name, "name") {
                name = it
            }
        }
    }

    public fun identification(): List<InstanceIdentifier> = identificationList
}